PROC TABULATE DATA=gia19 NOSEPS MISSING order=data;
CLASS  health_type / PRELOADFMT MLF;
LABEL SUBTL_ACT_RTD_SEP_CNE="Total Participants, End of Year (thousands)"
	  TOT_ACTIVE_PARTCP_CNE="Active Participants, End of Year (thousands)"
	  TOT_ASSETS_EOY_AME="Total Assets (millions)"
	  TOT_CONTRIB_AME="Total Contributions (millions)"
	  TOT_DISTRIB_BNFT_AME="Total Benefits (millions)";
VAR TOT_ACTIVE_PARTCP_CNE TOT_ASSETS_EOY_AME SUBTL_ACT_RTD_SEP_CNE TOT_ACTIVE_PARTCP_CNE / WEIGHT=DUP_WGT;
VAR TOT_CONTRIB_AME TOT_DISTRIB_BNFT_AME;
VAR DUP_WGT;
TITLE 'Table 2.  Number of Group Insurance Arrangements (GIAs) Providing Health Benefits, Total ';
TITLE2 'Participants, Active Participants, Assets, Contributions, and Benefits';
TITLE3 "by type of benefit, 2019";
KEYLABEL ALL='Total';
TABLE ALL health_type=' ', 
    SUM=' '*DUP_WGT='Number of GIAs'*F=COMMA13. (SUM=' '*(SUBTL_ACT_RTD_SEP_CNE
TOT_ACTIVE_PARTCP_CNE))*F=K13F.
	SUM=' '*(TOT_ASSETS_EOY_AME TOT_CONTRIB_AME TOT_DISTRIB_BNFT_AME)*f=m12f_2stars. / 
    RTS=41 Box='Type of Benefit'  MISSTEXT='-';

RUN;
